

import java.io.IOException;

// Definicin de excepciones empleadas por la aplicacin
class ExcepcionDeVocal extends Exception {
}

class ExcepcionDeNumero extends Exception {
}

class ExcepcionDeBlanco extends Exception {
}

class ExcepcionDeSalida extends Exception {
}

class PruebaDeExcepciones {
	// atributos
	LeerTeclado kbd = new LeerTeclado(System.in);

	// mtodos
	public void procesarEntradaUsuario() throws ExcepcionDeVocal,
			ExcepcionDeBlanco, ExcepcionDeSalida, ExcepcionDeNumero {
		System.out.print("Introduzca un carcter: ");
		System.out.flush();
		char ch;

		try {
			ch = Character.toUpperCase(kbd.getChar());
		} // try
		catch (IOException x) {

			System.out.println("Se ha producido una IOException.");
			return;
		} // catch

		switch (ch) {
		case 'A':
		case 'E':
		case 'I':
		case 'O':
		case 'U':
			throw new ExcepcionDeVocal();
		case '1':
		case '2':
		case '3':
		case '4':
		case '5':
		case '6':
		case '7':
		case '8':
		case '9':
		case '0':
			throw new ExcepcionDeNumero();
		case ' ':
			throw new ExcepcionDeBlanco();
		case 'X':
			throw new ExcepcionDeSalida();
		} // switch
	} // procesar_Entrada_Usuario

	public static void main(String args[]) {

		PruebaDeExcepciones miPrueba = new PruebaDeExcepciones();
		boolean fin = false;
		do {
			try {
				miPrueba.procesarEntradaUsuario();
			} catch (ExcepcionDeVocal x) {
				System.out.println("Se ha producido excepcin de vocal.");
			} catch (ExcepcionDeNumero x) {
				System.out.println("Se ha producido excepcin de nmero.");
			} catch (ExcepcionDeBlanco x) {
				System.out.println("Se ha producido excepcin de blanco.");
			} catch (ExcepcionDeSalida x) {
				System.out.println("Se ha producido excepcin de salida.");
				fin = true;
			} finally {
				System.out.println("Estamos en la clusula finally.\n");
			} // finally
		} while (!fin);
	} // main
} // class